#ifndef LCD16X2_H
#define LCD16X2_H

#include <math.h>
#include "types.h"
#include "integer.h"
#include "p33FJ64GP802.h"

#define LCDRS		(LATBbits.LATB0)
#define LCDE		(LATBbits.LATB1)

#define LCDCOMMAND	0
#define LCDDATA		1

#define LCDDELAY	10
#define NUM_DIGITS	6

extern void delayMs(int);
void sendShiftRegister(BYTE);
void writeLCD(BYTE, BYTE);
extern BYTE disFix(BYTE);
void disaLCD(BYTE, BYTE);
void initLCD(void);
int printITOA(unsigned char*, unsigned long, int, int, int);
int printFDecimal(unsigned char*, double, int, int);
int printFSignedDecimal(unsigned char*, double, int, int);
void disFUnsignedLCD(BYTE, double, int, int, int);
void disdecfreeLCD(int, int);
void writeStringLCD(BYTE, char*, int);
int writeStringLCDInternal(char*);

#endif
